#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
void DBG() { cerr << "]" << endl; }
template<class H, class... T> void DBG(H h, T... t) { cerr << to_string(h); if(sizeof...(t)) cerr << ", "; DBG(t...); }
#define dbg(...) cerr << "[" << #__VA_ARGS__ << "]: [", DBG(__VA_ARGS__)

struct fenwick_tree {
    vector<int> bit;
    void init(int n) {
        bit.assign(n + 1, 0);
    }
    void clear_all(int n) {
        for (int i = 0; i <= n; i++)
            bit[i] = 0;
    }

    int sum(int i) {
        int s = 0;
        while (i > 0) {
            s += bit[i];
            i -= (i & (-i));
        }
        return s;
    }
    void add(int i, int val, int n) {
        while (i > 0 && i <= n) {
            bit[i] += val;
            i += (i & (-i));
        }
    }
    int get(int l, int r) {
        return sum(r) - (l > 0 ? sum(l-1) : 0);
    }
};

const int N = 2e5 + 3;
const int inf = 1e9;
const double EPS = 1e-5;
ll x[N], v[N];
pair<long double, int> vec[N];

void solve() {
    fenwick_tree fenwick;
    ll n, k;
    scanf("%lld %lld", &n, &k);
    fenwick.init(n);
    for (int i = 1; i <= n; i++) {
        scanf("%lld %lld", &x[i], &v[i]);
    }

    long double l = 0.0, r = 1e9;
    while (l + EPS < r) {
        long double t = (l + r) / 2.0;
        ll preticanja = 0;
        fenwick.clear_all(n);

        for (int i = 1; i <= n; i++) {
            vec[i] = {x[i] + (long double)(t * v[i]), i};
        }
        sort(vec + 1, vec + n + 1);

        int p = 1;
        for (int i = 1; i <= n; i++) {
            long double v; int j;
            tie(v, j) = vec[i];
            while (p <= n && vec[p].first == v) {
                fenwick.add(vec[p++].second, 1, n);
            }

            ll pr = fenwick.get(j + 1, n);
            preticanja += pr;
        }

        if (preticanja >= k) {
            r = t;
        } else
            l = t;
    }

    printf("%.5Lf\n", r);
}

int main() {
    solve();
}